﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Entities
{
    public class PhysicsComponent : Component
    {
        public Vector2 Velocity = Vector2.Zero;
        public Vector2 Heading = Vector2.Zero;
        public Vector2 Side = Vector2.Zero;
        public float Mass = 0.5f;
        public float MaxSpeed = 5f;
        public float MaxForce = 10f;
        public float MaxTurnRate = 3f;

        public PhysicsComponent(string name)
            : base(name)
        {
        }

        public override void CopyTo(Component component)
        {
            PhysicsComponent p = (PhysicsComponent)component;
            p.Velocity = this.Velocity;
            p.Heading = this.Heading;
            p.Side = this.Side;
            p.Mass = this.Mass;
            p.MaxSpeed = this.MaxSpeed;
            p.MaxForce = this.MaxForce;
            p.MaxTurnRate = this.MaxTurnRate;
            base.CopyTo(p);
        }
    }
}
